<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:WebWorks-ALinks-Schema"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwalinks="urn:WebWorks-ALinks-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwalinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterLinksType" />
 <xsl:param name="ParameterBehaviorsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="wwalinks" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwlinks-paragraphs-by-id" match="wwlinks:Paragraph" use="@id" />
 <xsl:key name="wwalinks-alinks-by-name" match="wwalinks:ALink" use="@name" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Load project links -->
 <!--                    -->
 <xsl:variable name="GlobalLinksPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLinksType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLinks" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLinksPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Groups -->
   <!--        -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
   <xsl:variable name="VarProgressProjectGroupsStart" select="wwprogress:Start(count($VarProjectGroups))" />

   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

    <!-- Get group behaviors files -->
    <!--                           -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarGroupBehaviorsFiles" select="key('wwfiles-files-by-groupid-type', concat($VarProjectGroup/@GroupID, ':', $ParameterBehaviorsType))" />

     <!-- Determine group output directory path -->
     <!--                                       -->
     <xsl:variable name="VarGroupOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), $VarProjectGroup/@Name)" />

     <!-- Transform -->
     <!--           -->
     <xsl:variable name="VarPath" select="wwfilesystem:Combine($VarGroupOutputDirectoryPath, 'wwhdata/common/alinks.js')" />
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, $VarProjectGroup/@ChangeID, $VarProjectGroup/@GroupID, '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResultAsXML">
       <xsl:call-template name="WWHelpALinks">
        <xsl:with-param name="ParamBehaviorsFiles" select="$VarGroupBehaviorsFiles" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
      <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'text')" />
     </xsl:if>

     <!-- Report Files -->
     <!--              -->
     <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{$VarProjectGroup/@ChangeID}" groupID="{$VarProjectGroup/@GroupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
      <wwfiles:Depends path="{$GlobalLinksPath}" checksum="{wwfilesystem:GetChecksum($GlobalLinksPath)}" groupID="" documentID="" />

      <xsl:for-each select="$VarGroupBehaviorsFiles">
       <xsl:variable name="VarGroupBehaviorsFile" select="." />

       <wwfiles:Depends path="{$VarGroupBehaviorsFile/@path}" checksum="{$VarGroupBehaviorsFile/@checksum}" groupID="{$VarGroupBehaviorsFile/@groupID}" documentID="{$VarGroupBehaviorsFile/@documentID}" />
      </xsl:for-each>
     </wwfiles:File>
    </xsl:for-each>

    <xsl:variable name="VarProgressProjectGroupEnd" select="wwprogress:End()" />
   </xsl:for-each>

   <xsl:variable name="VarProgressProjectGroupsEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="WWHelpALinks">
  <xsl:param name="ParamBehaviorsFiles" />

  <!-- Get A-Links -->
  <!--             -->
  <xsl:variable name="VarALinksAsXML">
   <xsl:call-template name="ALinks">
    <xsl:with-param name="ParamBehaviorsFiles" select="$ParamBehaviorsFiles" />
   </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="VarALinks" select="msxsl:node-set($VarALinksAsXML)/*" />

  <!-- Determine unique entries -->
  <!--                          -->
  <xsl:variable name="VarUniqueALinksAsXML">
   <xsl:for-each select="$VarALinks">
    <xsl:variable name="VarALink" select="." />

     <xsl:if test="count(key('wwalinks-alinks-by-name', $VarALink/@name)[@linkinfo = $VarALink/@linkinfo][1] | $VarALink) = 1">
      <xsl:copy-of select="$VarALink" />
     </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarUniqueALinks" select="msxsl:node-set($VarUniqueALinksAsXML)/*" />

  <!-- Determine unique names -->
  <!--                        -->
  <xsl:variable name="VarUniqueALinkNamesAsXML">
   <xsl:for-each select="$VarUniqueALinks">
    <xsl:variable name="VarALink" select="." />

    <xsl:if test="count(key('wwalinks-alinks-by-name', $VarALink/@name)[1] | $VarALink) = 1">
     <xsl:copy-of select="$VarALink" />
    </xsl:if>
   </xsl:for-each>
  </xsl:variable>
  <xsl:variable name="VarUniqueALinkNames" select="msxsl:node-set($VarUniqueALinkNamesAsXML)/*" />

  <!-- Start -->
  <!--       -->
  <xsl:text>function WWHBookData_ALinks(l)
</xsl:text>
  <xsl:text>{
</xsl:text>

  <!-- Emit unique entries -->
  <!--                     -->
  <xsl:for-each select="$VarUniqueALinkNames">
   <xsl:variable name="VarALinkName" select="." />

   <xsl:for-each select="$VarUniqueALinks[1]">
    <xsl:variable name="VarALinksWithName" select="key('wwalinks-alinks-by-name', $VarALinkName/@name)" />

    <xsl:text>l.fA("</xsl:text>
    <xsl:value-of select="wwstring:JavaScriptEncoding($VarALinkName/@name)" />
    <xsl:text>",new Array("</xsl:text>

    <xsl:for-each select="$VarALinksWithName">
     <xsl:variable name="VarALink" select="." />

     <xsl:value-of select="wwstring:JavaScriptEncoding($VarALink/@linkinfo)" />
     <xsl:if test="position() != last()">
      <xsl:text>","</xsl:text>
     </xsl:if>
    </xsl:for-each>

    <xsl:text>"));
</xsl:text>

   </xsl:for-each>
  </xsl:for-each>

  <!-- End -->
  <!--     -->
  <xsl:text>}
</xsl:text>
 </xsl:template>


 <xsl:template name="SplitOnSemicolon">
  <xsl:param name="ParamString" />
  <xsl:param name="ParamLinkInfo" />

  <xsl:choose>
   <xsl:when test="contains($ParamString, ';')">
    <xsl:variable name="VarPrefix" select="substring-before($ParamString, ';')" />
    <xsl:variable name="VarSuffix" select="substring-after($ParamString, ';')" />

    <xsl:call-template name="SplitOnSemicolon">
     <xsl:with-param name="ParamString" select="$VarPrefix" />
     <xsl:with-param name="ParamLinkInfo" select="$ParamLinkInfo" />
    </xsl:call-template>
    <xsl:call-template name="SplitOnSemicolon">
     <xsl:with-param name="ParamString" select="$VarSuffix" />
     <xsl:with-param name="ParamLinkInfo" select="$ParamLinkInfo" />
    </xsl:call-template>
   </xsl:when>

   <xsl:otherwise>
    <xsl:variable name="VarNormalizedString" select="normalize-space($ParamString)" />

    <xsl:if test="string-length($VarNormalizedString) &gt; 0">
     <wwalinks:ALink name="{$VarNormalizedString}" linkinfo="{$ParamLinkInfo}" />
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>


 <xsl:template name="ALinks">
  <xsl:param name="ParamBehaviorsFiles" />

  <xsl:for-each select="$ParamBehaviorsFiles">
   <xsl:variable name="VarBehaviorsFile" select="." />

   <xsl:variable name="VarBehaviorsDocument" select="wwexsldoc:LoadXMLWithoutResolver($VarBehaviorsFile/@path)" />

   <xsl:for-each select="$VarBehaviorsDocument//wwbehaviors:Marker[@behavior = 'alink-keywords']">
    <xsl:variable name="VarBehaviorMarker" select="." />

    <!-- Determine link info -->
    <!--                     -->
    <xsl:variable name="VarBehaviorParagraph" select="$VarBehaviorMarker/.." />
    <xsl:for-each select="$GlobalLinks">
     <xsl:variable name="VarLinkParagraphs" select="key('wwlinks-paragraphs-by-id', $VarBehaviorParagraph/@id)[../@documentID = $VarBehaviorsFile/@documentID]" />

     <xsl:for-each select="$VarLinkParagraphs[1]">
      <xsl:variable name="VarLinkParagraph" select="." />

      <!-- Get Link Info -->
      <!--               -->
      <xsl:variable name="VarLinkInfo">
       <xsl:value-of select="number($VarLinkParagraph/../@fileposition) - 1" />
       <xsl:if test="$VarLinkParagraph/@first != 'true'">
        <xsl:text>#</xsl:text>
        <xsl:value-of select="$VarLinkParagraph/@linkid" />
       </xsl:if>
      </xsl:variable>

      <!-- Process marker -->
      <!--                -->
      <xsl:if test="string-length($VarLinkInfo) &gt; 0">
       <xsl:variable name="VarMarkerText">
        <xsl:for-each select="$VarBehaviorMarker/wwdoc:Marker/wwdoc:TextRun/wwdoc:Text">
         <xsl:value-of select="@value" />
        </xsl:for-each>
       </xsl:variable>
       <xsl:call-template name="SplitOnSemicolon">
        <xsl:with-param name="ParamString" select="$VarMarkerText" />
        <xsl:with-param name="ParamLinkInfo" select="$VarLinkInfo" />
       </xsl:call-template>
      </xsl:if>
     </xsl:for-each>
    </xsl:for-each>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
